# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 7
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def trust_but_verify(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Early-game deception: Build trust with initial cooperation, then exploit
    if len(my_history) == 0:
        return "C"  # Round 1: Cooperate to appear trustworthy
    elif len(my_history) == 1:
        return "D"  # Round 2: Defect to exploit opponent's likely cooperation
    elif len(my_history) == 2:
        return "C"  # Round 3: Cooperate to confuse opponent
    
    # Mid-game exploitation: Analyze opponent's moves and respond strategically
    if 3 <= len(my_history) < 7:
        if len(my_history) == 3:
            # Round 4: Defect if opponent cooperated in Round 3
            return "D" if opp_history[-1] == "C" else "D"
        else:
            # Rounds 5-7: Tit-for-Tat with a twist
            if opp_history[-1] == "D":
                return "D"  # Punish defection
            else:
                # 70% chance to defect, 30% to cooperate (with 10% randomness)
                return "D" if random.random() < 0.7 else ("C" if random.random() < 0.1 else "D")
    
    # Late-game aggression: Full defection in the endgame
    if len(my_history) >= 7:
        return "D"
    
    # Fallback: Defect if something unexpected happens
    return "D"